<?php
include('authentication.php');
include('includes/header.php');
include('includes/navbar.php');
include('dbcon.php');

$id = $_GET['id'];
$data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM tbl_inquiry WHERE id='$id'"));

function getNextInvoiceNumber($conn) {
    $result = mysqli_query($conn, "SELECT gst_invoice_no FROM tbl_client ORDER BY id DESC LIMIT 1");
    $row = mysqli_fetch_assoc($result);
    if($row && !empty($row['gst_invoice_no'])) {
        $lastNumber = (int) filter_var($row['gst_invoice_no'], FILTER_SANITIZE_NUMBER_INT);
        $nextNumber = $lastNumber + 1;
    } else {
        $nextNumber = 01;
    }
    return "" . $nextNumber;
}
?>

<div class="container-fluid">
    <div class="inquiry-container">
    <h2>Complete Service & Add Client</h2>

    <form action="service-done-code.php" method="POST">
        <input type="hidden" name="id" value="<?= $data['id']; ?>">
            <h5 class="text-primary">Customer Details</h5><hr>

            <label>Name</label>
            <input type="text" value="<?= $data['name']; ?>" readonly>

            <label class="mt-3">Phone</label>
            <input type="text" class="" value="<?= $data['phone']; ?>" readonly>

            <label class="mt-3">Email</label>
            <input type="text"  value="<?= $data['email']; ?>" readonly>

            <label class="mt-3">Address</label>
            <textarea  readonly><?= $data['address']; ?></textarea>

            <hr><h5 class="text-success">Service Details</h5><hr>
            <label>Service Name</label>
            <input type="text" name="service"  required>

            <label class="mt-3">Service Date</label>
            <input type="date" name="service_date" required>

            <label class="mt-3">Terms & Conditions</label>
            <textarea name="service_term_condition"  required></textarea>

            <label class="mt-3">Total Amount</label>
            <input type="number" name="total_amount"  required>

            <label class="mt-3">Warranty</label>
            <input type="text" name="warranty" required>

            <label class="mt-3">Service Covered</label>
            <textarea name="service_covered"  required></textarea>

            <hr><h5 class="text-warning">GST Details</h5><hr>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" id="apply_gst" name="apply_gst" value="1" onclick="toggleGSTFields()">
                <label class="form-check-label" for="apply_gst">Apply GST (18%)</label>
            </div>

            <div id="gst_fields" style="display:none;">
                <label class="mt-3">Billing Address</label>
                <textarea name="billing_address" ></textarea>

                <label class="mt-3">Shipping Address</label>
                <textarea name="shipping_address" ></textarea>

                <label class="mt-3">GST Invoice No</label>
                <input type="text" name="gst_invoice_no"  value="<?= getNextInvoiceNumber($conn); ?>" readonly>
            </div>

 
        <button class="btn btn-primary btn-block mt-3">Save Client</button>
    </form>
</div>
</div>

<script>
function toggleGSTFields() {
    var gstFields = document.getElementById('gst_fields');
    gstFields.style.display = document.getElementById('apply_gst').checked ? 'block' : 'none';
}
</script>

<?php 
include('includes/scripts.php'); 
include('includes/footer.php'); 
?>
